/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.android.api;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import cn.jpush.android.api.DefaultPushNotificationBuilder;
import cn.jpush.android.api.PushNotificationBuilder;
import cn.jpush.android.helper.Logger;
import cn.jpush.android.service.JNotifyActivity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MultiActionsNotificationBuilder
extends DefaultPushNotificationBuilder {
    private static final String TAG = "MultiActionsNotificationBuilder";
    private static final String NOTI_ACT_RES_ID = "notification_action_res_id";
    private static final String NOTI_ACT_TEXT = "notification_action_text";
    private static final String NOTI_ACT_EXTRA_STR = "notification_action_extra_string";
    private static final String INTENT_NOTIFICATION_CLICK_ACTION_PROXY = "cn.jpush.android.intent.NOTIFICATION_CLICK_ACTION_PROXY";
    protected Context mContext;
    private JSONArray actionJSONArray = new JSONArray();

    public MultiActionsNotificationBuilder(Context context) {
        this.mContext = context;
    }

    public void addJPushAction(int n, String string, String string2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(NOTI_ACT_RES_ID, n);
            jSONObject.put(NOTI_ACT_TEXT, (Object)string);
            jSONObject.put(NOTI_ACT_EXTRA_STR, (Object)string2);
            this.actionJSONArray.put((Object)jSONObject);
            Logger.i(TAG, this.actionJSONArray.toString());
        }
        catch (JSONException jSONException) {
            Logger.ww(TAG, "Construct action failed!");
            jSONException.printStackTrace();
        }
    }

    @Override
    @TargetApi(value=11)
    Notification getNotification(Notification.Builder builder) {
        if (Build.VERSION.SDK_INT >= 16) {
            for (int i = 0; i < this.actionJSONArray.length(); ++i) {
                try {
                    JSONObject jSONObject = this.actionJSONArray.getJSONObject(i);
                    Intent intent = new Intent(INTENT_NOTIFICATION_CLICK_ACTION_PROXY);
                    intent.putExtra("cn.jpush.android.NOTIFIACATION_ACTION_EXTRA", jSONObject.getString(NOTI_ACT_EXTRA_STR));
                    PendingIntent pendingIntent = null;
                    intent.setClass(this.mContext, JNotifyActivity.class);
                    intent.putExtra("isNotification", true);
                    pendingIntent = PendingIntent.getActivity((Context)this.mContext, (int)i, (Intent)intent, (int)0x8000000);
                    Logger.i(TAG, "Add notification action: res - " + jSONObject.getInt(NOTI_ACT_RES_ID) + ", string - " + jSONObject.getString(NOTI_ACT_TEXT) + ", extra - " + jSONObject.getString(NOTI_ACT_EXTRA_STR));
                    builder.addAction(jSONObject.getInt(NOTI_ACT_RES_ID), (CharSequence)jSONObject.getString(NOTI_ACT_TEXT), pendingIntent).setAutoCancel(true);
                    continue;
                }
                catch (JSONException jSONException) {
                    Logger.ww(TAG, "Parse Action from preference preference failed!");
                    jSONException.printStackTrace();
                }
            }
            return builder.build();
        }
        Logger.i(TAG, "Device with SDK_VERSION < 16, show original notification style.");
        return builder.getNotification();
    }

    public static PushNotificationBuilder parseFromPreference(Context context, String string) {
        MultiActionsNotificationBuilder multiActionsNotificationBuilder = new MultiActionsNotificationBuilder(context);
        try {
            multiActionsNotificationBuilder.actionJSONArray = new JSONArray(string);
        }
        catch (JSONException jSONException) {
            Logger.ww(TAG, "Parse builder from preference failed!");
            jSONException.printStackTrace();
        }
        return multiActionsNotificationBuilder;
    }

    @Override
    public String toString() {
        return this.actionJSONArray.toString();
    }
}

