/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.android.api;

import android.app.NotificationManager;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import cn.jiguang.api.JCoreManager;
import cn.jpush.android.api.PushNotificationBuilder;
import cn.jpush.android.api.TagAliasCallback;
import cn.jpush.android.data.JPushLocalNotification;
import cn.jpush.android.helper.JCoreHelper;
import cn.jpush.android.helper.Logger;
import cn.jpush.android.helper.b;
import cn.jpush.android.helper.c;
import cn.jpush.android.helper.d;
import cn.jpush.android.local.ActionHelper;
import cn.jpush.android.local.JPushConstants;
import cn.jpush.android.s.a;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class JPushInterface {
    public static final String PUSH_MESSAGE_PERMISSION_POSTFIX = ".permission.JPUSH_MESSAGE";
    public static final String ACTION_CONNECTION_CHANGE = "cn.jpush.android.intent.CONNECTION";
    public static final String ACTION_REGISTRATION_ID = "cn.jpush.android.intent.REGISTRATION";
    public static final String ACTION_MESSAGE_RECEIVED = "cn.jpush.android.intent.MESSAGE_RECEIVED";
    public static final String ACTION_NOTIFICATION_RECEIVED = "cn.jpush.android.intent.NOTIFICATION_RECEIVED";
    public static final String ACTION_NOTIFICATION_OPENED = "cn.jpush.android.intent.NOTIFICATION_OPENED";
    public static final String ACTION_NOTIFICATION_CLICK_ACTION = "cn.jpush.android.intent.NOTIFICATION_CLICK_ACTION";
    public static final String ACTION_NOTIFICATION_CLICK_ACTION_PROXY = "cn.jpush.android.intent.NOTIFICATION_CLICK_ACTION_PROXY";
    public static final String ACTION_NOTIFICATION_RECEIVED_PROXY = "cn.jpush.android.intent.NOTIFICATION_RECEIVED_PROXY";
    public static final String EXTRA_CONNECTION_CHANGE = "cn.jpush.android.CONNECTION_CHANGE";
    public static final String EXTRA_REGISTRATION_ID = "cn.jpush.android.REGISTRATION_ID";
    public static final String EXTRA_APP_KEY = "cn.jpush.android.APPKEY";
    public static final String EXTRA_NOTIFICATION_DEVELOPER_ARG0 = "cn.jpush.android.NOTIFICATION_DEVELOPER_ARG0";
    public static final String EXTRA_NOTIFICATION_TITLE = "cn.jpush.android.NOTIFICATION_CONTENT_TITLE";
    public static final String EXTRA_NOTIFICATION_URL = "cn.jpush.android.NOTIFICATION_URL";
    public static final String EXTRA_PUSH_ID = "cn.jpush.android.PUSH_ID";
    public static final String EXTRA_MSG_ID = "cn.jpush.android.MSG_ID";
    public static final String EXTRA_NOTI_TYPE = "cn.jpush.android.NOTIFICATION_TYPE";
    public static final String EXTRA_ALERT = "cn.jpush.android.ALERT";
    public static final String EXTRA_ALERT_TYPE = "cn.jpush.android.ALERT_TYPE";
    public static final String EXTRA_MESSAGE = "cn.jpush.android.MESSAGE";
    public static final String EXTRA_CONTENT_TYPE = "cn.jpush.android.CONTENT_TYPE";
    public static final String EXTRA_TITLE = "cn.jpush.android.TITLE";
    public static final String EXTRA_BIG_TEXT = "cn.jpush.android.BIG_TEXT";
    public static final String EXTRA_INBOX = "cn.jpush.android.INBOX";
    public static final String EXTRA_BIG_PIC_PATH = "cn.jpush.android.BIG_PIC_PATH";
    public static final String EXTRA_EXTRA = "cn.jpush.android.EXTRA";
    public static final String EXTRA_NOTI_PRIORITY = "cn.jpush.android.NOTI_PRIORITY";
    public static final String EXTRA_NOTI_CATEGORY = "cn.jpush.android.NOTI_CATEGORY";
    public static final String EXTRA_NOTIFICATION_ID = "cn.jpush.android.NOTIFICATION_ID";
    public static final String EXTRA_NOTIFICATION_ACTION_EXTRA = "cn.jpush.android.NOTIFIACATION_ACTION_EXTRA";
    public static final String EXTRA_NOTIFICATION_SMALL_ICON = "cn.jpush.android.NOTIFICATION_SMALL_ICON";
    public static final String EXTRA_NOTIFICATION_LARGET_ICON = "cn.jpush.android.NOTIFICATION_LARGE_ICON";
    public static final String EXTRA_ACTIVITY_PARAM = "cn.jpush.android.ACTIVITY_PARAM";
    public static final String EXTRA_RICHPUSH_FILE_PATH = "cn.jpush.android.FILE_PATH";
    public static final String EXTRA_RICHPUSH_FILE_TYPE = "cn.jpush.android.FILE_TYPE";
    public static final String EXTRA_RICHPUSH_HTML_PATH = "cn.jpush.android.HTML_PATH";
    public static final String EXTRA_RICHPUSH_HTML_RES = "cn.jpush.android.HTML_RES";
    public static final String EXTRA_STATUS = "cn.jpush.android.STATUS";
    public static int DEFAULT_NOTIFICATION_NUM = 5;
    private static final Integer a = 0;
    public static final String ACTION_RICHPUSH_CALLBACK = "cn.jpush.android.intent.ACTION_RICHPUSH_CALLBACK";

    public static void init(Context context) {
        Logger.dd("JPushInterface", "action:init - sdkVersion:" + JPushConstants.SDK_VERSION_NAME + ", buildId:" + JPushConstants.BUILD_ID);
        JPushInterface.checkContext(context);
        boolean bl = cn.jpush.android.u.a.g(context);
        if (!bl) {
            return;
        }
        JPushConstants.init(context);
        JCoreHelper.runActionWithService(context, "JPUSH", "init", null);
        ActionHelper.getInstance().doSingleAction(context, "third_init", null);
    }

    public static void resumePush(Context context) {
        Logger.dd("JPushInterface", "action:resumePush");
        JPushInterface.checkContext(context);
        JCoreHelper.runActionWithService(context, "JPUSH", "resume", null);
        ActionHelper.getInstance().doSingleAction(context, "third_resume", null);
    }

    public static void stopPush(Context context) {
        Logger.dd("JPushInterface", "action:stopPush");
        JPushInterface.checkContext(context);
        JCoreHelper.runActionWithService(context, "JPUSH", "stop", null);
        ActionHelper.getInstance().doSingleAction(context, "third_stop", null);
    }

    public static boolean isPushStopped(Context context) {
        JPushInterface.checkContext(context);
        JCoreHelper.runActionWithService(context, "JPUSH", "check_stop", null);
        return cn.jpush.android.cache.a.d(context);
    }

    public static void setDebugMode(boolean bl) {
        JCoreManager.setDebugMode((boolean)bl);
    }

    public static void setChannel(Context context, String string) {
        JCoreHelper.setChannel(context, string);
    }

    public static void setPushTime(Context context, Set<Integer> set, int n, int n2) {
        JPushInterface.checkContext(context);
        if (!cn.jpush.android.u.a.a(context)) {
            Logger.dd("JPushInterface", "\u68c0\u6d4b\u5230\u5f53\u524d\u6ca1\u6709\u7f51\u7edc\u3002\u6b64\u52a8\u4f5c\u5c06\u5728\u6709\u7f51\u7edc\u65f6\u81ea\u52a8\u7ee7\u7eed\u6267\u884c\u3002");
        }
        if (null == set) {
            Bundle bundle = new Bundle();
            bundle.putString("time", "0123456_0^23");
            JCoreHelper.runActionWithService(context, "JPUSH", "pushtime", bundle);
            return;
        }
        if (set.size() == 0 || set.isEmpty()) {
            JCoreHelper.runActionWithService(context, "JPUSH", "disable_push", null);
            return;
        }
        if (n > n2) {
            Logger.ee("JPushInterface", "Invalid time format - startHour should less than endHour");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer n3 : set) {
            if (n3 > 6 || n3 < 0) {
                Logger.ee("JPushInterface", "Invalid day format - " + n3);
                return;
            }
            stringBuilder.append(n3);
        }
        stringBuilder.append("_");
        stringBuilder.append(n);
        stringBuilder.append("^");
        stringBuilder.append(n2);
        Bundle bundle = new Bundle();
        bundle.putString("time", stringBuilder.toString());
        JCoreHelper.runActionWithService(context, "JPUSH", "pushtime", bundle);
    }

    public static void setSilenceTime(Context context, int n, int n2, int n3, int n4) {
        JPushInterface.checkContext(context);
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n2 > 59 || n4 > 59 || n3 > 23 || n > 23) {
            Logger.ee("JPushInterface", "Invalid parameter format, startHour and endHour should between 0 ~ 23, startMins and endMins should between 0 ~ 59. ");
            return;
        }
        if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
            Bundle bundle = new Bundle();
            bundle.putString("time", "");
            JCoreHelper.runActionWithService(context, "JPUSH", "silenceTime", bundle);
            Logger.dd("JPushInterface", "Remove the silence time!");
            return;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("startHour", n);
            jSONObject.put("startMins", n2);
            jSONObject.put("endHour", n3);
            jSONObject.put("endtMins", n4);
            Bundle bundle = new Bundle();
            bundle.putString("time", jSONObject.toString());
            JCoreHelper.runActionWithService(context, "JPUSH", "silenceTime", bundle);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static String getRegistrationID(Context context) {
        JPushInterface.checkContext(context);
        JCoreHelper.runActionWithService(context, "JPUSH", "get_rid", null);
        return JCoreHelper.getRegistrationID(context);
    }

    private static void checkContext(Context context) {
        if (null == context) {
            throw new IllegalArgumentException("NULL context");
        }
        JPushConstants.mApplicationContext = context.getApplicationContext();
    }

    public static String getUdid(Context context) {
        JPushInterface.checkContext(context);
        return JCoreHelper.getDeviceId(context);
    }

    public static void setLatestNotificationNumber(Context context, int n) {
        JPushInterface.checkContext(context);
        Logger.dd("JPushInterface", "action:setLatestNotificationNumber : " + n);
        if (n <= 0) {
            Logger.ee("JPushInterface", "maxNum should > 0, Give up action..");
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("num", n);
        JCoreHelper.runActionWithService(context, "JPUSH", "max_num", bundle);
    }

    public static void clearAllNotifications(Context context) {
        JPushInterface.checkContext(context);
        JCoreHelper.runActionWithService(context, "JPUSH", "clear_all_notify", null);
    }

    public static void clearNotificationById(Context context, int n) {
        JPushInterface.checkContext(context);
        if (n <= 0) {
            Logger.ee("JPushInterface", "Invalid notificationId, Give up action..");
            return;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.cancel(n);
    }

    public static void setDefaultPushNotificationBuilder(PushNotificationBuilder pushNotificationBuilder) {
        if (null == pushNotificationBuilder) {
            throw new IllegalArgumentException("NULL notification");
        }
        Bundle bundle = new Bundle();
        bundle.putInt("buidler_id", a.intValue());
        bundle.putString("buidler_string", pushNotificationBuilder.toString());
        JCoreHelper.runActionWithService(JPushConstants.mApplicationContext, "JPUSH", "set_custom_notify", bundle);
    }

    public static void setPushNotificationBuilder(Integer n, PushNotificationBuilder pushNotificationBuilder) {
        Logger.vv("JPushInterface", "action:setPushNotificationBuilder - id:" + n);
        if (null == pushNotificationBuilder) {
            throw new IllegalArgumentException("NULL pushNotificationBuilder");
        }
        if (n < 1) {
            Logger.ee("JPushInterface", "id should be larger than 0");
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("buidler_id", n.intValue());
        bundle.putString("buidler_string", pushNotificationBuilder.toString());
        JCoreHelper.runActionWithService(JPushConstants.mApplicationContext, "JPUSH", "set_custom_notify", bundle);
    }

    @Deprecated
    public void setAliasAndTags(Context context, String string, Set<String> set) {
        JPushInterface.checkContext(context);
        JPushInterface.setAliasAndTags(context, string, set, null);
    }

    @Deprecated
    public static void setAliasAndTags(Context context, String string, Set<String> set, TagAliasCallback tagAliasCallback) {
        JPushInterface.checkContext(context);
        ActionHelper.getInstance().setAliasAndTagsWithCallBack(context, string, set, tagAliasCallback, 0, 0);
    }

    @Deprecated
    public static void setTags(Context context, Set<String> set, TagAliasCallback tagAliasCallback) {
        JPushInterface.checkContext(context);
        JPushInterface.setAliasAndTags(context, null, set, tagAliasCallback);
    }

    @Deprecated
    public static void setAlias(Context context, String string, TagAliasCallback tagAliasCallback) {
        JPushInterface.checkContext(context);
        JPushInterface.setAliasAndTags(context, string, null, tagAliasCallback);
    }

    public static Set<String> filterValidTags(Set<String> set) {
        return cn.jpush.android.s.a.a(set);
    }

    public static void setTags(Context context, int n, Set<String> set) {
        JPushInterface.checkContext(context);
        ActionHelper.getInstance().setTagsWithCallBack(context, n, set, 1, 2);
    }

    public static void addTags(Context context, int n, Set<String> set) {
        JPushInterface.checkContext(context);
        ActionHelper.getInstance().setTagsWithCallBack(context, n, set, 1, 1);
    }

    public static void deleteTags(Context context, int n, Set<String> set) {
        JPushInterface.checkContext(context);
        ActionHelper.getInstance().setTagsWithCallBack(context, n, set, 1, 3);
    }

    public static void cleanTags(Context context, int n) {
        JPushInterface.checkContext(context);
        ActionHelper.getInstance().setTagsWithCallBack(context, n, new HashSet<String>(), 1, 4);
    }

    public static void getAllTags(Context context, int n) {
        JPushInterface.checkContext(context);
        ActionHelper.getInstance().setTagsWithCallBack(context, n, new HashSet<String>(), 1, 5);
    }

    public static void checkTagBindState(Context context, int n, String string) {
        JPushInterface.checkContext(context);
        HashSet<String> hashSet = null;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            hashSet = new HashSet<String>();
            hashSet.add(string);
        }
        ActionHelper.getInstance().setTagsWithCallBack(context, n, hashSet, 1, 6);
    }

    public static void setAlias(Context context, int n, String string) {
        JPushInterface.checkContext(context);
        ActionHelper.getInstance().setAliasWithCallBack(context, n, string, 2, 2);
    }

    public static void deleteAlias(Context context, int n) {
        JPushInterface.checkContext(context);
        ActionHelper.getInstance().setAliasWithCallBack(context, n, null, 2, 3);
    }

    public static void getAlias(Context context, int n) {
        JPushInterface.checkContext(context);
        ActionHelper.getInstance().setAliasWithCallBack(context, n, null, 2, 5);
    }

    public static void setMobileNumber(Context context, int n, String string) {
        JPushInterface.checkContext(context);
        d.a().a(context, n, string);
    }

    public static void reportNotificationOpened(Context context, String string) {
        JPushInterface.checkContext(context);
        if (TextUtils.isEmpty((CharSequence)string)) {
            Logger.ee("JPushInterface", "The msgId is not valid - " + string);
        }
        c.a(string, 1028, context);
    }

    public static void reportNotificationOpened(Context context, String string, byte by) {
        JPushInterface.checkContext(context);
        if (TextUtils.isEmpty((CharSequence)string)) {
            Logger.ee("JPushInterface", "The msgId is not valid - " + string);
        }
        c.a(string, "", by, 1000, context);
    }

    @Deprecated
    public static boolean getConnectionState(Context context) {
        JPushInterface.checkContext(context);
        JCoreHelper.runActionWithService(context, "JPUSH", "get_connection", null);
        return JCoreManager.getConnectionState((Context)context);
    }

    public static void onResume(Context context) {
        JCoreHelper.saEvent(context, "resume", null);
    }

    public static void onPause(Context context) {
        JCoreHelper.saEvent(context, "pause", null);
    }

    public static void onFragmentResume(Context context, String string) {
        JCoreHelper.saEvent(context, "f_resume", string);
    }

    public static void onFragmentPause(Context context, String string) {
        JCoreHelper.saEvent(context, "f_pause", string);
    }

    public static void onKillProcess(Context context) {
        JCoreHelper.saEvent(context, "kill", null);
    }

    public static void setStatisticsSessionTimeout(long l) {
    }

    public static void setStatisticsEnable(boolean bl) {
    }

    public static void initCrashHandler(Context context) {
        JPushInterface.checkContext(context);
        JCoreManager.initCrashHandler((Context)context);
    }

    public static void stopCrashHandler(Context context) {
        JPushInterface.checkContext(context);
        JCoreManager.stopCrashHandler((Context)context);
    }

    public static void addLocalNotification(Context context, JPushLocalNotification jPushLocalNotification) {
        JPushInterface.checkContext(context);
        cn.jpush.android.n.d.a(context, jPushLocalNotification);
    }

    public static void removeLocalNotification(Context context, long l) {
        JPushInterface.checkContext(context);
        cn.jpush.android.n.d.a(context, l);
    }

    public static void clearLocalNotifications(Context context) {
        JPushInterface.checkContext(context);
        cn.jpush.android.n.d.a(context);
    }

    private static boolean checkLengthOfTags(String string) {
        int n = 0;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            n += string.getBytes().length;
        }
        Logger.v("JPushInterface", "tags length:" + n);
        return n <= 7000;
    }

    public static String getStringTags(Set<String> set) {
        return cn.jpush.android.s.a.b(set);
    }

    private static void setDefaultNotifactionNumber(Context context) {
        JPushInterface.setLatestNotificationNumber(context, DEFAULT_NOTIFICATION_NUM);
    }

    public static void requestPermission(Context context) {
        if (context == null) {
            Logger.ww("JPushInterface", "[requestPermission] unexcepted - context was null");
            return;
        }
        JCoreManager.requestPermission((Context)context);
    }

    public static void setDaemonAction(String string) {
    }

    public static void setPowerSaveMode(Context context, boolean bl) {
    }

    public static void setGeofenceInterval(Context context, long l) {
        JPushInterface.checkContext(context);
        if (l < 180000L || l > 86400000L) {
            Logger.ee("JPushInterface", "Invalid interval, it should be a ms number between 3 mins and 1 day!");
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("interval", l);
        JCoreHelper.runActionWithService(context, "JPUSH", "geo_interval", bundle);
    }

    public static void setMaxGeofenceNumber(Context context, int n) {
        JPushInterface.checkContext(context);
        if (n < 1 || n > 100) {
            Logger.ee("JPushInterface", "Invalid maxNumber,it should be a number between 1 and 100!");
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("num", n);
        JCoreHelper.runActionWithService(context, "JPUSH", "geo_fence_max_num", bundle);
    }

    public static void deleteGeofence(Context context, String string) {
        JPushInterface.checkContext(context);
        Bundle bundle = new Bundle();
        bundle.putString("id", string);
        JCoreHelper.runActionWithService(context, "JPUSH", "delete_geo_fence", bundle);
    }

    private static void taq() {
        JPushConstants.testAndroidQ();
    }

    public static void setBadgeNumber(Context context, int n) {
        context = JPushConstants.getAppContext(context);
        if (n < 0) {
            n = 0;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("num", n);
        JCoreHelper.runActionWithService(context, "JPUSH", "set_badge", bundle);
    }

    public static void setLbsEnable(Context context, boolean bl) {
        try {
            JCoreManager.setLBSEnable((Context)context, (boolean)bl);
        }
        catch (Throwable throwable) {
            Logger.ee("JPushInterface", "not found [setLBSEnable] in jcore");
        }
        try {
            if (!bl) {
                cn.jpush.android.cache.a.c(context, false);
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("enable", bl);
            JCoreHelper.runActionWithService(context, "JPUSH", "enable_lbs", bundle);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void attachBaseContext(Context context) {
        try {
            long l = System.currentTimeMillis();
            Class.forName("cn.jpush.android.dy.JPushThirdDyManager").getDeclaredMethod("attachBaseContext", Context.class).invoke(null, context);
            Logger.d("JPushInterface", "use time:" + (System.currentTimeMillis() - l));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int isNotificationEnabled(Context context) {
        return cn.jpush.android.p.b.d(context);
    }

    public static void goToAppNotificationSettings(Context context) {
        boolean bl = cn.jpush.android.p.b.e(context);
        if (!bl) {
            cn.jpush.android.p.b.f(context);
        }
    }

    public static void setThirdPushEnable(Context context, boolean bl) {
        try {
            JPushConstants.THIRD_ENABLE = bl;
            Bundle bundle = new Bundle();
            bundle.putBoolean("enable", bl);
            JCoreHelper.runActionWithService(context, "JPUSH", "third_enable", bundle);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void reportWakedData(Context context, Bundle bundle, int n) {
        JPushInterface.checkContext(context);
        try {
            JCoreManager.reportWakedData((Context)context, (Bundle)bundle, (int)n);
        }
        catch (Throwable throwable) {
            Logger.ee("JPushInterface", "not found [reportWakedData] in jcore");
        }
    }

    static {
        JCoreManager.addDispatchAction((String)"JPUSH", (String)b.class.getName());
    }

    public static class ErrorCode {
        public static int SUCCESS = 0;
        public static int NULL_TAGANDALIAS = 6001;
        public static int TIMEOUT = 6002;
        public static int INVALID_ALIAS = 6003;
        public static int TOO_LONG_ALIAS = 6004;
        public static int INVALID_TAGS = 6005;
        public static int TOO_LONG_TAGS = 6006;
        public static int TOO_MANY_TAGS = 6007;
        public static int TOO_LONG_TAGALIAS = 6008;
        public static int UNKNOWN_ERROR = 6009;
        public static int INVALID_JSON = 6010;
        public static int INVOKE_TOO_SOON = 6011;
        public static int PUSH_STOPED = 6012;
        public static int INCORRECT_TIME = 6013;
        public static int ERROR_CODE_TOO_BUSY = 6014;
        public static int ERROR_CODE_BLACKLIST = 6015;
        public static int ERROR_CODE_INVALIDUSER = 6016;
        public static int ERROR_CODE_INVALIDREQ = 6017;
        public static int ERROR_CODE_TOO_MANY_TAGS = 6018;
        public static int ERROR_CODE_GET_FAILED = 6019;
        public static int ERROR_CODE_SERVER_UNAVAILABLE = 6020;
        public static int ERROR_CODE_TAG_OPERATORING = 6021;
        public static int ERROR_CODE_ALIAS_OPERATORING = 6022;
        public static int ERROR_CODE_INVALID_MOBILENUMBER = 6023;
        public static int ERROR_CODE_INTERNEL_SERVER_ERROR = 6024;
        public static int ERROR_CODE_TOO_LONG_MOBILENUMBER = 6025;
        public static int ERROR_CODE_ALIAS_LIMIT = 6027;
    }
}

