/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.android.api;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.widget.RemoteViews;
import cn.jpush.android.api.BasicPushNotificationBuilder;
import cn.jpush.android.helper.Logger;

public class CustomPushNotificationBuilder
extends BasicPushNotificationBuilder {
    public int layoutTimeId;
    public int layout;
    public int layoutIconId;
    public int layoutTitleId;
    public int layoutContentId;
    public int layoutIconDrawable = 0;

    CustomPushNotificationBuilder(Context context) {
        super(context);
    }

    public CustomPushNotificationBuilder(Context context, int n, int n2, int n3, int n4, int n5) {
        super(context);
        this.layout = n;
        this.layoutTitleId = n3;
        this.layoutContentId = n4;
        this.layoutTimeId = n5;
        this.layoutIconId = n2;
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
            if (null == applicationInfo) {
                Logger.ee("CustomPushNotificationB", "JPush get NULL appInfo.");
                return;
            }
            this.layoutIconDrawable = applicationInfo.icon;
        }
        catch (Throwable throwable) {
            Logger.ww("CustomPushNotificationB", "[statusBarDrawable] JPush get NULL appInfo.");
        }
    }

    public CustomPushNotificationBuilder(Context context, int n, int n2, int n3, int n4) {
        super(context);
        this.layout = n;
        this.layoutIconId = n2;
        this.layoutTitleId = n3;
        this.layoutContentId = n4;
    }

    @Override
    RemoteViews buildContentView(String string, String string2) {
        RemoteViews remoteViews = new RemoteViews(this.a.getPackageName(), this.layout);
        remoteViews.setTextViewText(this.layoutTitleId, (CharSequence)string2);
        remoteViews.setImageViewResource(this.layoutIconId, this.layoutIconDrawable);
        remoteViews.setTextViewText(this.layoutContentId, (CharSequence)string);
        if (this.layoutTimeId != 0) {
            remoteViews.setLong(this.layoutTimeId, "setTime", System.currentTimeMillis());
        }
        return remoteViews;
    }

    @Override
    public String toString() {
        return "custom_____" + this.a();
    }

    @Override
    String a() {
        return super.a() + "_____" + this.layout + "_____" + this.layoutIconId + "_____" + this.layoutTitleId + "_____" + this.layoutContentId + "_____" + this.layoutIconDrawable + "_____" + this.layoutTimeId;
    }

    @Override
    void a(String[] stringArray) {
        super.a(stringArray);
        this.layout = Integer.parseInt(stringArray[5]);
        this.layoutIconId = Integer.parseInt(stringArray[6]);
        this.layoutTitleId = Integer.parseInt(stringArray[7]);
        this.layoutContentId = Integer.parseInt(stringArray[8]);
        this.layoutIconDrawable = Integer.parseInt(stringArray[9]);
        if (stringArray.length == 11) {
            this.layoutTimeId = Integer.parseInt(stringArray[10]);
        }
    }
}

